<?php
/*
  $Id: pdf_catalogue.php,v 1.1 2003/02/04 GurvanRiou$

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/
if (is_admin($admin) == false) {
   die ("You can't access this file directly Admin Only...");
}
 if (!eregi("modules.php", $PHP_SELF)) { die ("You can't access this file directly..."); } 
define('FPDF_FONTPATH','font/');

require('pdf_config.php');
require('fpdf.php');
require('includes/application_top.php');

class PDF extends FPDF
{
//Colonne courante
var $col=0;
//Ordonne du dbut des colonnes
var $y0;

var $categories_string_spe = '';
var $categories_string = '';
var $categories_id = '';
var $levels = '';

var $parent_category_name;

 function Header()
 {

	
    $this->SetFont('Arial','B',15);
	$this->SetLineWidth(0.2);
    $w=$this->GetStringWidth(PDF_TITLE)+6;
    //$this->SetX((210-$w)/2);
    $this->Cell($w,9,PDF_TITLE,1,0,'C');
	
	//Anne en cour
	$aujourdhui = getdate();
	$annee = $aujourdhui['year'];
	
	$this->SetFont('Arial','B',12);
	$this->Cell(0,9,$annee,0,1,'R');
    $this->Ln(2);
	$x=$this->GetX();
	$y=$this->GetY();
	$this->Line($x,$y,200,$y);
	$this->Ln(2);
    //Sauvegarde de l'ordonne
    $this->y0=$this->GetY();
 }

 function Footer()
 {
    //Pied de page
    $this->SetY(-15);
	$x=$this->GetX();
	$y=$this->GetY();
	$this->SetLineWidth(0.2);
	$this->Line($x,$y,200,$y);
    $this->SetFont('Arial','I',8);
    $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'R');
 }
 
 function CheckPageBreak($h)
 {
	//Si la hauteur h provoque un dbordement, saut de page manuel
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
 }
 
 function NbLines($w,$txt)
 {
	//Calcule le nombre de lignes qu'occupe un MultiCell de largeur w
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
 }

 function LineString($x,$y,$txt,$cellheight)
 {
		//calculate the width of the string
		$stringwidth=$this->GetStringWidth($txt);
			
		//calculate the width of an alpha/numerical char
		$numberswidth=$this->GetStringWidth('1');
			
		$xpos=($x+$numberswidth);
			
	    $ypos=($y+($cellheight/2));
			
		$this->Line($xpos,$ypos,($xpos+$stringwidth),$ypos);
 }
 
function ShowImage(&$width,&$height,$link,$path)
{

	$width=min($width,MAX_IMAGE_WIDTH);
	$height=min($height,MAX_IMAGE_HEIGHT);

	if(RESIZE_IMAGES)
	{
		$destination =DIR_FS_CATALOG."catalogues/";
		
   		
   		if(substr(strtolower($path), (strlen($path)-4),4)==".jpg" || substr(strtolower($path), (strlen($path)-5),5)==".jpeg")
   		{
      		$src=imagecreatefromjpeg($path);
   		}
		else if(substr(strtolower($path), (strlen($path)-4),4)==".png")
   		{
      		$src=imagecreatefrompng($path);
   		}
   		else
   		{
      		echo "Only PNG and JPEG";
      		exit();
   		}
   
   		$array=explode("/", $path);
   		$last=sizeof($array);
   
   		$size = getimagesize($path);
   		if($size[0] > $size[1])
   		{
     		$im=imagecreate($width/PDF_TO_MM_FACTOR, $height/PDF_TO_MM_FACTOR);
     		imagecopyresized($im, $src, 0, 0, 0, 0,$width/PDF_TO_MM_FACTOR, $height/PDF_TO_MM_FACTOR, $size[0], $size[1]);
   		}
   		else
   		{
     		$im=imagecreate($height/PDF_TO_MM_FACTOR,$width/PDF_TO_MM_FACTOR);
     		imagecopyresized($im, $src, 0, 0, 0, 0, $height/PDF_TO_MM_FACTOR, $width/PDF_TO_MM_FACTOR, $size[0], $size[1]);
  		}
  		 if(!imagejpeg($im, $destination.$array[$last-1]))
   		{
    		  exit();
   		}
		
		$path=$destination.$array[$last-1];
		
		$this->SetLineWidth(1);  
		$this->Cell($width,$height,"",1,0);
		$this->SetLineWidth(0.2);
		$this->Image($path,($this->GetX()-$width), $this->GetY(), $width, $height,'',$link);
		$this->SetFont('Arial','',8);
		
		unlink($path);
		
	}
	else
	{
		$this->SetLineWidth(1);  
		$this->Cell($width,$height,"",1,0);
		$this->SetLineWidth(0.2);
		$this->Image($path,($this->GetX()-$width), $this->GetY(), $width, $height,'',$link);
		$this->SetFont('Arial','',8);
	}
   
    
   
   
}

 
 
 function CountProductsInCategory($category_id, $include_inactive = false)
 {
    $products_count = 0;
    if ($include_inactive)
	{
      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id = '" . $category_id . "'");
    } 
	else
	{
      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = 1 and p2c.categories_id = '" . $category_id . "'");
    }
    $products = tep_db_fetch_array($products_query);
    $products_count += $products['total'];

    if (USE_RECURSIVE_COUNT)
	{
      $child_categories_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . $category_id . "'");
      if (tep_db_num_rows($child_categories_query))
	  {
        while ($child_categories = tep_db_fetch_array($child_categories_query))
		{
          $products_count += $this->CountProductsInCategory($child_categories['categories_id'], $include_inactive);
        }
      }
    }

    return $products_count;
 }

//Rangement de l'arbre (Level est le niveau de sous-categorie)
 function Order($cid, $level, $foo, $cpath)
 {
    if ($cid != 0)
	{
		if($level>1)
		{
		    $nbspaces=7;
	     
			$dessinrep="|___ ";
			//j'inverse le dessin
			$revstring = strrev($dessinrep);
			//je lui ajoute nbspace pour chaque niveau de sous-repertoire
		    $revstring .= str_repeat(" ",$nbspaces*($level-2));
			//je rinverse la chaine
	  	    $this->categories_string_spe .= strrev($revstring);			  
		}
	 
	  $this->levels .=$level." ";
	  $this->categories_id .= $cid." ";
	  $this->categories_string .= $foo[$cid]['name'];
      $this->categories_string_spe .=  $foo[$cid]['name'];
     
      if (SHOW_COUNTS)
	  {
        $products_in_category = $this->CountProductsInCategory($cid);
        if ($products_in_category > 0)
		{
          $this->categories_string_spe .= ' (' . $products_in_category . ')';
        }
      }
	  $this->categories_string .= "\n";
      $this->categories_string_spe .= "\n";
    
    }
  //Parcourir l'arbre des categories (lecture de la table de hachage comme en Perl)
    foreach ($foo as $key => $value)
	{
      if ($foo[$key]['parent'] == $cid)
	  {
        $this->Order($key, $level+1, $foo, $cid);
      }
    }
 }

 function ParentsName($current_category_level,$i,&$categorieslevelsarray, &$categoriesnamearray)
 {

		   $k=$i;
		 	while($k>0)
			{
				if($categorieslevelsarray[$k] == ($current_category_level-1))
				{
					$this->$parent_category_name=$categoriesnamearray[$k];
					break;
				}	
				
				$k--;
			}
 
 
 }
 
 function CalculatedSpace($y1,$y2,$imageheight)
 {
 	//Si les commentaires sont - importants que l'image au niveau de l'espace d'affichage
	if(($h2=$y2-$y1) < $imageheight)
	{
			$this->Ln(($imageheight-$h2)+3);
	}
	else
	{
						$this->Ln(3);
	}
 }
 
 function DrawCells($data_array)
 {
 	 $totallines=0;
	
	 
	 for($i=2;$i<(sizeof($data_array)-1);$i++)
	 {
	 	$totallines+=$this->NbLines((180-$data_array[0]),$data_array[$i]);
	 }
	 
	 //5 = hauteur des cellules
	 $h=5*$totallines."<br>";
	 
	 //si la description du produit ne prend pas toute la page
	 if($h<260)
	 {
	 	$this->CheckPageBreak($h);
	 }
	 
	 
	 if(SHOW_PRODUCTS_LINKS)
	 { 
	 	$link=HTTP_CATALOG_SERVER.DIR_CATALOG."product_info.php?products_id=".$data_array[10]."&language=".$data_array[11];
	 }
	 else
	 {
	 	 $link='';
	 }
	 
	 if(SHOW_IMAGES && strlen($data_array[11]))
	 {	
	 	//If Small Image Width and Small Image Height are defined
	 	if(strlen($data_array[0])>1 && strlen($data_array[1])>1)
		{
	 		$this->ShowImage($data_array[0],$data_array[1],$link,$data_array[12]);
	 		$y1=$this->GetY();
		}
	    //If only Small Image Width is defined
		else if(strlen($data_array[0])>1 && strlen($data_array[1]))
		{   
		    $heightwidth=getimagesize($data_array[11]);
			$data_array[0]=$data_array[0];
		    $data_array[1]=$heightwidth[1]*PDF_TO_MM_FACTOR;
			
	 		$this->ShowImage($data_array[0],$data_array[1],$link,$data_array[12]);
	 		$y1=$this->GetY();
		}
		//If only Small Image Height is defined
		else if(strlen($data_array[0]) && strlen($data_array[1])>1)
		{
			$heightwidth=getimagesize($data_array[11]);
			$data_array[0]=$width=$heightwidth[0]*PDF_TO_MM_FACTOR;
		    $data_array[1]=$data_array[1];
			
	 		$this->ShowImage($data_array[0],$data_array[1],$link,$data_array[12]);
	 		$y1=$this->GetY();
		}
		else
		{
			$heightwidth=getimagesize($data_array[12]);
			$data_array[0]=$heightwidth[0]*PDF_TO_MM_FACTOR;
		    $data_array[1]=$heightwidth[1]*PDF_TO_MM_FACTOR;
			
	 		$this->ShowImage($data_array[0],$data_array[1],$link,$data_array[12]);
	 		$y1=$this->GetY();
		}
		
		//Margin=10
		$this->SetX(10);
	}
	else
	{
		$data_array[0]=$data_array[1]=0;
		$y1=$this->GetY();
		$this->SetFont('Arial','',8);
	}
	 
	 if(SHOW_MODEL)
	 {
	 	if(strlen($data_array[2]))
		{
	 		$this->Cell($data_array[0]+3,5,"",0,0);
	 		$this->MultiCell(180-$data_array[0],5,$data_array[2],1,'L');
		}
	 }
	 if(SHOW_NAME)
	 {
	 	if(strlen($data_array[3]))
		{
	 		$this->Cell($data_array[0]+3,5,"",0,0);
	 		$this->MultiCell(180-$data_array[0],5,$data_array[3],1,'L');
		}
	 }
	 if(SHOW_DATE_ADDED)
	 {
	 	if(strlen($data_array[4]))
		{
	    	$this->Cell($data_array[0]+3,5,"",0,0);
	 		$this->MultiCell(180-$data_array[0],5,$data_array[4],1,'L');
		}
	 }
	 if(SHOW_MANUFACTURER)
	 {
	 	if(strlen($data_array[5]))
		{
	 		$this->Cell($data_array[0]+3,5,"",0,0);
	 		$this->MultiCell(180-$data_array[0],5,$data_array[5],1,'L');
		}
	 }
	 if(SHOW_DESCRIPTION)
	 {
	 	if(strlen($data_array[6]))
		{
	 		$this->Cell($data_array[0]+3,5,"",0,0);
	 		$this->MultiCell(180-$data_array[0],5,$data_array[6],1,'L');
		}
	 }
	 if(SHOW_TAX_CLASS_ID)
	 {
	 	if(strlen($data_array[7]))
		{
	    	$this->Cell($data_array[0]+3,5,"",0,0);
	 		$this->MultiCell(180-$data_array[0],5,$data_array[7],1,'L');
		}
	 
	 }
	 if(VAT)
	 {
		$vatprice=sprintf("%01.".DIGITS_AFTER_DOT."f",((VAT/100)*$data_array[9])+$data_array[9]);
		$vatspecialsprice=sprintf("%01.".DIGITS_AFTER_DOT."f",((VAT/100)*$data_array[8])+$data_array[8]);
	 }
	 else
	 {
	 	$vatprice=sprintf("%01.".DIGITS_AFTER_DOT."f",$data_array[9]);
	 	$vatspecialsprice=sprintf("%01.".DIGITS_AFTER_DOT."f",$data_array[8]);
	 }
	 if(SHOW_PRICES)
	 {
	 	if(strlen($data_array[8])) //If special price 
		{		
			$this->Cell($data_array[0]+3,5,"",0,0);
			
			$x=$this->GetX();
			$y=$this->GetY();
			
			$specials_price_color_table=explode(",",SPECIALS_PRICE_COLOR);
		    $this->SetFillColor($specials_price_color_table[0],$specials_price_color_table[1],$specials_price_color_table[2]);
			
			if(CURRENCY_RIGHT_OR_LEFT == 'R')
			{
				$this->MultiCell(180-$data_array[0],5,$vatprice.CURRENCY."\t\t\t".$vatspecialsprice.CURRENCY,1,'L',1);
			}
			else if(CURRENCY_RIGHT_OR_LEFT == 'L')
			{
	  			$this->MultiCell(180-$data_array[0],5,CURRENCY.$vatprice."\t\t\t".CURRENCY.$vatspecialsprice,1,'L',1);
			}
			else
			{
				echo "<b>Choose L or R for CURRENCY_RIGHT_OR_LEFT</b>";
				exit();
			}
			$this->LineString($x,$y,$vatprice,5);
			
		}
		else if(strlen($data_array[9]))
		{
			$this->Cell($data_array[0]+3,5,"",0,0);
			if(CURRENCY_RIGHT_OR_LEFT == 'R')
			{
				$this->MultiCell(180-$data_array[0],5,$vatprice.CURRENCY,1,'L');
			}
			else if(CURRENCY_RIGHT_OR_LEFT == 'L')
			{
				$this->MultiCell(180-$data_array[0],5,CURRENCY.$vatprice,1,'L');
			}
			else
			{
				echo "<b>Choose L or R for CURRENCY_RIGHT_OR_LEFT</b>";
				exit();
			}	
		}
	 }
	 
	 $y2=$this->GetY();
	 
	 //si la description du produit ne prend pas toute la page
	 if($h<260)
	 {
		 $this->CalculatedSpace($y1,$y2,$data_array[1]);
 	 }
	 else
	 {
	 	$this->Ln(3);
	 }
 
 }
 
 function CategoriesTree($languages_id)
 { 
	//selectionne toute les categories
	$query = "SELECT c.categories_id, cd.categories_name, c.parent_id
              FROM " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd
              WHERE c.categories_id = cd.categories_id and cd.language_id='" . $languages_id ."'
		      ORDER by sort_order, cd.categories_name";

	$categories_query = tep_db_query($query);

     while ($categories = tep_db_fetch_array($categories_query))
     {
      //Table de hachage
      $foo[$categories['categories_id']] = array(
											     'name' => $categories['categories_name'],
											     'parent' => $categories['parent_id']
											    );
    }
 
  $this->Order(0, 0, $foo, '');
  $this->AddPage();
  $this->TitreChapitre("");
  $this->Ln(10);
  $this->SetFont('Arial','',DIRECTORIES_TREE_FONT_SIZE);
  $this->MultiCell(0,6,$this->categories_string_spe,0,1,'L');
  
  
 }
 
 function CategoriesListing($languages_id, $languages_code)
 {   
	 //Recuperation de toutes les categories dans l'ordre
	 $categoriesidarray=explode(" ",$this->categories_id);
	 $categoriesnamearray=explode("\n",$this->categories_string);
	 $categorieslevelsarray=explode(" ",$this->levels);
	 
	  
	  //Convertion pixels -> mm
	  $imagewidth=SMALL_IMAGE_WIDTH*PDF_TO_MM_FACTOR;
	  $imageheight=SMALL_IMAGE_HEIGHT*PDF_TO_MM_FACTOR;
	 
	  		
	 for($i=0; $i<sizeof($categoriesidarray)-1; $i++)
	 {
	 	$taille=0;
	    $current_category_id=$categoriesidarray[$i];
		$current_category_name=$categoriesnamearray[$i];
		$current_category_level=$categorieslevelsarray[$i];
				
								
	    $requete_prod="select p.products_id, pd.products_name, pd.products_description, p.products_image, p.products_model, p.products_price, p.products_tax_class_id, IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, p.products_date_added, m.manufacturers_name from " . TABLE_PRODUCTS . " p left join " . TABLE_MANUFACTURERS . " m on p.manufacturers_id = m.manufacturers_id, " . TABLE_PRODUCTS_DESCRIPTION . " pd left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id, " . TABLE_CATEGORIES . " c, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where products_status = '1' and p.products_id = pd.products_id and pd.language_id = '" . $languages_id . "' and p.products_id = p2c.products_id and p2c.categories_id = c.categories_id and p2c.categories_id='".$current_category_id."' order by p.products_date_added DESC, pd.products_name";
							  
		$SHOW_catalog_query = tep_db_query($requete_prod);
			  
			  
		 while ($print_catalog = tep_db_fetch_array($SHOW_catalog_query))
		 {
			   $print_catalog_array[$taille++] = array(
											   			'id' => $print_catalog['products_id'],
			                                   			'name' => $print_catalog['products_name'],
			                                   			'description' => $print_catalog['products_description'],
			                                  			'model' => $print_catalog['products_model'],
			                                   			'image' => $print_catalog['products_image'],
			                                   			'price' => $print_catalog['products_price'],
											   			'specials_price' => $print_catalog['specials_new_products_price'],
			                                   			'tax_class_id' => $print_catalog['products_tax_class_id'],
			                                   			'date_added' => tep_date_long($print_catalog['products_date_added']),
			                                   			'manufacturer' => $print_catalog['manufacturers_name']
											   		  );
													  
	     }
		 
		 

		 //recherche le nom de la categorie pere
		$this->$parent_category_name='';
		$this->ParentsName($current_category_level,$i,$categorieslevelsarray, $categoriesnamearray);
		 
		 
		 if($current_category_level == 1)
		 {
		 	$this->AddPage();
			$this->Ln(120);
			$this->SetFont('Arial','',12);
    		$titles_color_table=explode(",",CENTER_TITLES_CELL_COLOR);
    		$this->SetFillColor($titles_color_table[0], $titles_color_table[1], $titles_color_table[2]);
			$this->Cell(45,5,"",0,0);
			$this->MultiCell(100,10,$current_category_name,1,'C',1);
		 }
		 
		 if($taille>0)
		 {
				
				$this->AddPage();
				$this->TitreChapitre($this->$parent_category_name." ---> ".$current_category_name);
  				$this->Ln(10);
  				$this->SetFont('Arial','',11);
  				
		
				for($j=0; $j<$taille; $j++ )
				{
					$imagepath=DIR_FS_CATALOG.DIR_WS_IMAGES.$print_catalog_array[$j]['image'];
					
					$id=$print_catalog_array[$j]['id'];
				 	$name=rtrim(strip_tags($print_catalog_array[$j]['name']));
					$model=rtrim(strip_tags($print_catalog_array[$j]['model']));
					$description=rtrim(strip_tags($print_catalog_array[$j]['description']));
					$manufacturer=rtrim(strip_tags($print_catalog_array[$j]['manufacturer']));
					$price=rtrim(strip_tags($print_catalog_array[$j]['price']));
					$specials_price=rtrim(strip_tags($print_catalog_array[$j]['specials_price']));
			        $tax_class_id=rtrim(strip_tags($print_catalog_array[$j]['tax_class_id']));
			        $date_added=rtrim(strip_tags($print_catalog_array[$j]['date_added']));
					
					
					$data_array=array($imagewidth,$imageheight,$model,$name,$date_added,$manufacturer,$description,$tax_class_id,$specials_price,$price,$id,$languages_code,$imagepath);
					
					$this->DrawCells($data_array);
					
								  
				}
		} 		  
			
	 }
			
			
	 
     
 }
 
 function NewProducts($languages_id, $languages_code)
 {
 	$products_new_query_raw = "select p.products_id, pd.products_name, pd.products_description, p.products_image, p.products_model, p.products_price, p.products_tax_class_id, IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, p.products_date_added, m.manufacturers_name from " . TABLE_PRODUCTS . " p left join " . TABLE_MANUFACTURERS . " m on p.manufacturers_id = m.manufacturers_id, " . TABLE_PRODUCTS_DESCRIPTION . " pd left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id, " . TABLE_CATEGORIES . " c, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where products_status = '1' and p.products_id = pd.products_id and pd.language_id = '" . $languages_id . "' and p.products_id = p2c.products_id and p2c.categories_id = c.categories_id order by p.products_date_added DESC, pd.products_name";
	
    $products_new_query = tep_db_query($products_new_query_raw);
   
    while($products_new = tep_db_fetch_array($products_new_query))
	{
      $products_new_array[] = array('id' => $products_new['products_id'],
                                  'name' => $products_new['products_name'],
                                  'image' => $products_new['products_image'],
								  'description' => $products_new['products_description'],
								  'model' => $products_new['products_model'],
                                  'price' => $products_new['products_price'],
                                  'specials_price' => $products_new['specials_new_products_price'],
                                  'tax_class_id' => $products_new['products_tax_class_id'],
                                  'date_added' => tep_date_long($products_new['products_date_added']),
                                  'manufacturer' => $products_new['manufacturers_name']);
   }
  
 	$this->AddPage();
	$this->Ln(120);
	$this->SetFont('Arial','',12);
	$new_color_table=explode(",",NEW_CELL_COLOR);
    $this->SetFillColor($new_color_table[0], $new_color_table[1], $new_color_table[2]);
	$this->Cell(45,5,"",0,0);
	$this->MultiCell(100,10,NEW_TITLE,1,'C',1);
	$this->Ln(100);
	
	//Convertion pixels -> mm
	$imagewidth=SMALL_IMAGE_WIDTH*PDF_TO_MM_FACTOR;
	$imageheight=SMALL_IMAGE_HEIGHT*PDF_TO_MM_FACTOR;
			
	for($nb=0; $nb<MAX_DISPLAY_PRODUCTS_NEW; $nb++)
	{
			
			$id=$products_new_array[$nb]['id'];
			$name=rtrim(strip_tags($products_new_array[$nb]['name']));
			$model=rtrim(strip_tags($products_new_array[$nb]['model']));
			$description=rtrim(strip_tags($products_new_array[$nb]['description']));
		    $manufacturer=rtrim(strip_tags($products_new_array[$nb]['manufacturer']));
			$price=rtrim(strip_tags($products_new_array[$nb]['price']));
			$specials_price=rtrim(strip_tags($products_new_array[$nb]['specials_price']));
			$tax_class_id=rtrim(strip_tags($products_new_array[$nb]['tax_class_id']));
			$date_added=rtrim(strip_tags($products_new_array[$nb]['date_added']));
			
			$imagepath=DIR_FS_CATALOG.DIR_WS_IMAGES.$products_new_array[$nb]['image'];
			
			$data_array=array($imagewidth,$imageheight,$model,$name,$date_added,$manufacturer,$description,$tax_class_id,$specials_price,$price,$id,$languages_code,$imagepath);
			
			
			
			$this->DrawCells($data_array);
			
    }
 
 }

 function TitreChapitre($lib)
 {
    //Titre
    $this->SetFont('Arial','',12);
    $titles_color_table=explode(",",HIGHT_TITLES_CELL_COLOR);
    $this->SetFillColor($titles_color_table[0], $titles_color_table[1], $titles_color_table[2]);
    $this->Cell(0,6,$lib,0,1,'L',1);
    $this->Ln(4);
    //Sauvegarde de l'ordonne
    $this->y0=$this->GetY();
 }
}

$languages = tep_get_languages();

$languages_string = '';

for ($i=0; $i<sizeof($languages); $i++)
{
	$pdf=new PDF();
	$pdf->Open();
	$pdf->SetDisplayMode("real");
	$pdf->AliasNbPages();
	if(SHOW_NEW_PRODUCTS)
	{
		$pdf->NewProducts($languages[$i]['id'],$languages[$i]['code']);
	}
	$pdf->CategoriesTree($languages[$i]['id']);
	$pdf->CategoriesListing($languages[$i]['id'],$languages[$i]['code']);
	$pdf->Output(DIR_FS_CATALOG."catalogues/catalog_".$languages[$i]['id'].".pdf",false);
}

echo "<br><br><br><table align=center><tr><td><h1><font color=red>".$i." </font>".GENERATED."</h1></td></tr></table>";



?>